/*
 * lcdd.h : linux deamon for a LCD panel header file
 *          Used for communitacion with ABng system
 *          LCD panel connected via serial port
 */

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <net/if.h>
#include <varargs.h>
#include <signal.h>
#include <errno.h>
#include <string.h>
#include <termio.h>
#include <fcntl.h>
#include <netdb.h>

/* General-purpose constants */

#define LCDD_CFILE "/etc/lcdd.conf"      /* Default config file location */
#define LCDD_PIDFILE "/var/run/lcdd.pid" /* PID file location */
#define LINEMAX 16                       /* Maximum length of the line */
#define MAXL 48				 /* Maximum length of the message */
#define NMAX 10                          /* Maximum number of messages */
#define EOM 0x0                          /* End of message delimiter */
#define PANEL_RST TIOCM_RTS              /* Port line used for hardware reset (may be also TIOCM_DTR) */
#define PANEL_ST 1                       /* Time to wait after hardware reset in seconds) */
#define PANEL_TIMEOUT 18                 /* Panel inactivity timeout (used for NOP) */
#define LCDD_TIMEOUT 8                   /* Maximum time of command completion (in seconds) */
#define LCDD_MAXATT 2                    /* Maximum attempts */
#define LCDD_IF	"eth0"			 /* Network interface to be configured */
#define LCDD_CONT 1			 /* Work continuously without bothering LCDD_MAXATT */

/* Protocol-dependent constants : */

#define PANEL_LM 'D'  /* Dn       : PC->uC : Load n messages */
#define PANEL_ACK A   /* ??? Acknowledge ???*/
#define PANEL_RM 'R'  /* Rn       : uC->PC : Request for message n */
#define PANEL_SM 'M'  /* Mn"text" : PC->uC : Sending message n */
#define PANEL_CM 'M'  /* Mn"text" : uC->PC : Confirm receiving message n (by sending echo) */
#define PANEL_BG "B"  /* B        : uC->PC : Begin work after succesful messages download */
#define PANEL_EX "E"  /* En / E0"IP_ADR/MASK" : uC->PC : Execute n-th command/set ip address/mask */
#define PANEL_ER 'R'  /* Rn"text" : PC->uC : Sending execution results */
#define PANEL_INIT "I"/* I        : uC->PC : Sent after reset */ 
#define PANEL_NOP "N" /* N        : uC->PC : NOP sent every ... seconds */


struct message
{
 char *text;
 char *command;
};
 
int restart=0; /* Set to 1, if SIGHUP received */
int finish=0;  /* Set to 1, if SIGINT received */
int attempts=0;/* No. of attempts to perform the operation */
static int sigcaught=0;
int linelength=LINEMAX;
int maxlength=MAXL;


char *pname=NULL;


int receiveString(int fd, char *reply);

/* For getting ifconfig */
						
int inet_sock=-1;
int skfd=-1;
