/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.extension;

import hidden.org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import org.apache.maven.MavenArtifactFilterManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.extension.ExtensionManager;
import org.apache.maven.model.Extension;
import org.apache.maven.plugin.DefaultPluginManager;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.Wagon;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class DefaultExtensionManager
extends AbstractLogEnabled
implements ExtensionManager,
Contextualizable {
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource artifactMetadataSource;
    private PlexusContainer container;
    private ArtifactFilter artifactFilter = MavenArtifactFilterManager.createStandardFilter();
    private WagonManager wagonManager;
    private static final String CONTAINER_NAME = "extensions";

    public void addExtension(Extension extension, MavenProject project, ArtifactRepository localRepository) throws ArtifactResolutionException, PlexusContainerException, ArtifactNotFoundException {
        String extensionId = ArtifactUtils.versionlessKey(extension.getGroupId(), extension.getArtifactId());
        this.getLogger().debug("Initialising extension: " + extensionId);
        Artifact artifact = (Artifact)project.getExtensionArtifactMap().get(extensionId);
        if (artifact != null) {
            ResolutionGroup resolutionGroup;
            ProjectArtifactExceptionFilter filter = new ProjectArtifactExceptionFilter(this.artifactFilter, project.getArtifact());
            try {
                resolutionGroup = this.artifactMetadataSource.retrieve(artifact, localRepository, project.getRemoteArtifactRepositories());
            }
            catch (ArtifactMetadataRetrievalException e) {
                throw new ArtifactResolutionException("Unable to download metadata from repository for plugin '" + artifact.getId() + "': " + e.getMessage(), artifact, e);
            }
            DefaultPluginManager.checkPlexusUtils(resolutionGroup, this.artifactFactory);
            HashSet<Artifact> dependencies = new HashSet<Artifact>(resolutionGroup.getArtifacts());
            dependencies.add(artifact);
            ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(dependencies, project.getArtifact(), Collections.EMPTY_MAP, localRepository, project.getRemoteArtifactRepositories(), this.artifactMetadataSource, filter);
            PlexusContainer extensionContainer = this.getExtensionContainer();
            if (extensionContainer == null) {
                extensionContainer = this.container.createChildContainer(CONTAINER_NAME, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
            }
            Set artifacts = result.getArtifacts();
            if (this.extensionContainsLifeycle(artifact.getFile())) {
                Iterator i = artifacts.iterator();
                while (i.hasNext()) {
                    Artifact a = (Artifact)i.next();
                    if (!this.artifactFilter.include(a)) continue;
                    this.getLogger().debug("Adding extension to core container: " + a.getFile());
                    this.container.addJarResource(a.getFile());
                }
            } else if (artifacts.size() == 2) {
                Iterator i = artifacts.iterator();
                while (i.hasNext()) {
                    Artifact a = (Artifact)i.next();
                    if (a.getArtifactId().equals("plexus-utils")) continue;
                    a = project.replaceWithActiveArtifact(a);
                    this.getLogger().debug("Adding extension to core container: " + a.getFile());
                    this.container.addJarResource(a.getFile());
                }
            } else {
                Iterator i = result.getArtifacts().iterator();
                while (i.hasNext()) {
                    Artifact a = (Artifact)i.next();
                    a = project.replaceWithActiveArtifact(a);
                    this.getLogger().debug("Adding to extension classpath: " + a.getFile());
                    extensionContainer.addJarResource(a.getFile());
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                extensionContainer.getContainerRealm().display();
            }
        }
    }

    public void registerWagons() {
        PlexusContainer extensionContainer = this.getExtensionContainer();
        if (extensionContainer != null) {
            try {
                Map wagons = extensionContainer.lookupMap(Wagon.ROLE);
                this.wagonManager.registerWagons(wagons.keySet(), extensionContainer);
            }
            catch (ComponentLookupException componentLookupException) {
                // empty catch block
            }
        }
    }

    private PlexusContainer getExtensionContainer() {
        return this.container.getChildContainer(CONTAINER_NAME);
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }

    private boolean extensionContainsLifeycle(File extension) {
        try {
            JarFile f = new JarFile(extension);
            InputStream is = f.getInputStream(f.getEntry("META-INF/plexus/components.xml"));
            if (is == null) {
                return false;
            }
            Xpp3Dom dom = Xpp3DomBuilder.build(new InputStreamReader(is));
            Xpp3Dom[] components = dom.getChild("components").getChildren("component");
            for (int i = 0; i < components.length; ++i) {
                if (!components[i].getChild("role").getValue().equals("org.apache.maven.lifecycle.mapping.LifecycleMapping")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static final class ProjectArtifactExceptionFilter
    implements ArtifactFilter {
        private ArtifactFilter passThroughFilter;
        private String projectDependencyConflictId;

        ProjectArtifactExceptionFilter(ArtifactFilter passThroughFilter, Artifact projectArtifact) {
            this.passThroughFilter = passThroughFilter;
            this.projectDependencyConflictId = projectArtifact.getDependencyConflictId();
        }

        public boolean include(Artifact artifact) {
            String depConflictId = artifact.getDependencyConflictId();
            return this.projectDependencyConflictId.equals(depConflictId) || this.passThroughFilter.include(artifact);
        }
    }
}

