/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertificateInfo;
import com.sun.deploy.util.DeployUIManager;
import com.sun.deploy.util.DialogFactory;
import com.sun.deploy.util.Trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import sun.misc.HexDumpEncoder;
import sun.security.x509.SerialNumber;

public class CertificateDialog {
    private Certificate[] certs = null;
    private int start = 0;
    private int end = 0;
    private Component parentComponent;
    JTree certChainTree = null;
    final JTable certInfoTable = new JTable();
    final JTextArea textArea = new JTextArea();
    Object[] msg;
    Object[] options;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public CertificateDialog(Certificate[] certificateArray, int n, int n2) {
        this(null, certificateArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertificateDialog(Component component, Certificate[] certificateArray, int n, int n2) {
        if (certificateArray == null || n < 0 || n2 < 0 || n > n2) {
            throw new IllegalArgumentException("Arguments to CertificateDialog constructor is not valid");
        }
        LookAndFeel lookAndFeel = null;
        try {
            lookAndFeel = DeployUIManager.setLookAndFeel();
            this.certs = certificateArray;
            this.start = n;
            this.end = n2;
            this.parentComponent = component;
            UIManager.getBorder("TableHeader.cellBorder");
            UIManager.getBorder("Table.focusCellHighlightBorder");
            UIManager.getColor("Table.focusCellForeground");
            UIManager.getColor("Table.focusCellBackground");
            JTable jTable = new JTable();
            jTable.getDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = CertificateDialog.class$("java.lang.String")) : class$java$lang$String);
            jTable.getDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = CertificateDialog.class$("java.lang.Object")) : class$java$lang$Object);
            if (certificateArray.length > n && certificateArray[n] instanceof X509Certificate) {
                Border border = BorderFactory.createEtchedBorder();
                this.certChainTree = this.buildCertChainTree(certificateArray, n, n2);
                this.certChainTree.addTreeSelectionListener(new TreeSelectionListener(){

                    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)CertificateDialog.this.certChainTree.getLastSelectedPathComponent();
                        if (defaultMutableTreeNode == null) {
                            return;
                        }
                        CertificateInfo certificateInfo = (CertificateInfo)defaultMutableTreeNode.getUserObject();
                        CertificateDialog.this.showCertificateInfo(certificateInfo.getCertificate());
                    }
                });
                this.showCertificateInfo((X509Certificate)certificateArray[n]);
                this.certInfoTable.setSelectionMode(0);
                ListSelectionModel listSelectionModel = this.certInfoTable.getSelectionModel();
                listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        int n = CertificateDialog.this.certInfoTable.getSelectedRow();
                        if (n == -1) {
                            return;
                        }
                        String string = (String)CertificateDialog.this.certInfoTable.getValueAt(n, 1);
                        CertificateDialog.this.textArea.setText(string);
                        CertificateDialog.this.textArea.repaint();
                    }
                });
                this.textArea.setLineWrap(false);
                this.textArea.setEditable(false);
                this.textArea.setRows(10);
                this.textArea.setColumns(40);
                Font font = ResourceManager.getUIFont();
                Font font2 = new Font("Monospaced", 0, font.getSize());
                this.textArea.setFont(font2);
                int n3 = font.getSize();
                this.certInfoTable.setRowSelectionInterval(6, 6);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                Dimension dimension = this.certInfoTable.getPreferredScrollableViewportSize();
                int n4 = Math.max(120, 8 + 7 * n3);
                dimension.setSize(dimension.getWidth(), (double)n4);
                this.certInfoTable.setPreferredScrollableViewportSize(dimension);
                JScrollPane jScrollPane = new JScrollPane(this.certInfoTable);
                jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0), jScrollPane.getBorder()));
                jPanel.add((Component)jScrollPane, "Center");
                jPanel.add((Component)new JScrollPane(this.textArea), "South");
                jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new BorderLayout());
                dimension = this.certChainTree.getPreferredScrollableViewportSize();
                dimension.setSize(200.0, 100.0);
                jScrollPane = new JScrollPane(this.certChainTree);
                jScrollPane.setPreferredSize(dimension);
                jPanel2.add((Component)jScrollPane, "West");
                jPanel2.add((Component)jPanel, "East");
                this.msg = new Object[]{jPanel2};
                JButton jButton = new JButton(CertificateDialog.getMessage("cert.dialog.close"));
                jButton.setMnemonic(CertificateDialog.getAcceleratorKey("cert.dialog.close"));
                this.options = new Object[]{jButton};
            }
            Object var19_18 = null;
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            DeployUIManager.restoreLookAndFeel(lookAndFeel);
            throw throwable;
        }
        DeployUIManager.restoreLookAndFeel(lookAndFeel);
    }

    public void DoModal() {
        if (!Trace.isAutomationEnabled()) {
            DialogFactory.showOptionDialog(this.parentComponent, (Object)this.msg, CertificateDialog.getMessage("cert.dialog.caption"), this.options, this.options[0]);
        }
    }

    private String formatDNString(String string) {
        int n = string.length();
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"' || c == '\'') {
                boolean bl3 = bl2 = !bl2;
            }
            if (c == ',' && !bl2) {
                stringBuffer.append(",\n");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private JTree buildCertChainTree(Certificate[] certificateArray, int n, int n2) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = n; i < certificateArray.length && i < n2; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new CertificateInfo((X509Certificate)certificateArray[i]));
            if (defaultMutableTreeNode == null) {
                defaultMutableTreeNode = defaultMutableTreeNode3;
                defaultMutableTreeNode2 = defaultMutableTreeNode3;
                continue;
            }
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
        }
        JTree jTree = new JTree(defaultMutableTreeNode);
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.putClientProperty("JTree.lineStyle", "Angled");
        return jTree;
    }

    private void showCertificateInfo(X509Certificate x509Certificate) {
        Object object;
        String string = "V" + x509Certificate.getVersion();
        String string2 = "[xxxxx-xxxxx]";
        try {
            object = new SerialNumber(x509Certificate.getSerialNumber());
            string2 = "[" + ((SerialNumber)object).getNumber() + "]";
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object = "[" + x509Certificate.getSigAlgName() + "]";
        String string3 = this.formatDNString(((Object)x509Certificate.getIssuerDN()).toString());
        String string4 = "[From: " + x509Certificate.getNotBefore() + ",\n To: " + x509Certificate.getNotAfter() + "]";
        String string5 = this.formatDNString(((Object)x509Certificate.getSubjectDN()).toString());
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string6 = hexDumpEncoder.encodeBuffer(x509Certificate.getSignature());
        Object[][] objectArray = new Object[][]{{CertificateDialog.getMessage("cert.dialog.field.Version"), string}, {CertificateDialog.getMessage("cert.dialog.field.SerialNumber"), string2}, {CertificateDialog.getMessage("cert.dialog.field.SignatureAlg"), object}, {CertificateDialog.getMessage("cert.dialog.field.Issuer"), string3}, {CertificateDialog.getMessage("cert.dialog.field.Validity"), string4}, {CertificateDialog.getMessage("cert.dialog.field.Subject"), string5}, {CertificateDialog.getMessage("cert.dialog.field.Signature"), string6}};
        Object[] objectArray2 = new String[]{CertificateDialog.getMessage("cert.dialog.field"), CertificateDialog.getMessage("cert.dialog.value")};
        this.certInfoTable.setModel(new DefaultTableModel(objectArray, objectArray2){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        });
        this.certInfoTable.setRowSelectionInterval(6, 6);
        this.certInfoTable.repaint();
        this.textArea.repaint();
    }

    private static String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    private static int getAcceleratorKey(String string) {
        return ResourceManager.getAcceleratorKey(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

