/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.security.AccessController;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import sun.awt.windows.ThemeReader;
import sun.security.action.GetPropertyAction;
import sun.swing.CachedPainter;

class XPStyle {
    private static XPStyle xp;
    private static SkinPainter skinPainter;
    private static Boolean themeActive;
    private HashMap<String, Border> borderMap;
    private HashMap<String, Color> colorMap;
    private boolean flatMenus = XPStyle.getSysBoolean(TMSchema.Prop.FLATMENUS);

    static synchronized void invalidateStyle() {
        xp = null;
        themeActive = null;
    }

    static synchronized XPStyle getXP() {
        if (themeActive == null) {
            GetPropertyAction getPropertyAction;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            themeActive = (Boolean)toolkit.getDesktopProperty("win.xpstyle.themeActive");
            if (themeActive == null) {
                themeActive = Boolean.FALSE;
            }
            if (themeActive.booleanValue() && AccessController.doPrivileged(getPropertyAction = new GetPropertyAction("swing.noxp")) == null && ThemeReader.isThemed() && !(UIManager.getLookAndFeel() instanceof WindowsClassicLookAndFeel)) {
                xp = new XPStyle();
            }
        }
        return xp;
    }

    String getString(Component component, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
        return XPStyle.getTypeEnumName(component, part, state, prop);
    }

    private static String getTypeEnumName(Component component, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
        int n = ThemeReader.getEnum(part.getControlName(component), part.getValue(), TMSchema.State.getValue(part, state), prop.getValue());
        if (n == -1) {
            return null;
        }
        return TMSchema.TypeEnum.getTypeEnum(prop, n).getName();
    }

    int getInt(Component component, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop, int n) {
        return ThemeReader.getInt(part.getControlName(component), part.getValue(), TMSchema.State.getValue(part, state), prop.getValue());
    }

    Dimension getDimension(Component component, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
        return ThemeReader.getPosition(part.getControlName(component), part.getValue(), TMSchema.State.getValue(part, state), prop.getValue());
    }

    Point getPoint(Component component, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
        Dimension dimension = ThemeReader.getPosition(part.getControlName(component), part.getValue(), TMSchema.State.getValue(part, state), prop.getValue());
        if (dimension != null) {
            return new Point(dimension.width, dimension.height);
        }
        return null;
    }

    Insets getMargin(Component component, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
        return ThemeReader.getThemeMargins(part.getControlName(component), part.getValue(), TMSchema.State.getValue(part, state), prop.getValue());
    }

    synchronized Color getColor(Skin skin, TMSchema.Prop prop, Color color) {
        String string = skin.toString() + "." + prop.name();
        TMSchema.Part part = skin.part;
        Color color2 = this.colorMap.get(string);
        if (color2 == null && (color2 = ThemeReader.getColor(part.getControlName(null), part.getValue(), TMSchema.State.getValue(part, skin.state), prop.getValue())) != null) {
            color2 = new ColorUIResource(color2);
            this.colorMap.put(string, color2);
        }
        return color2 != null ? color2 : color;
    }

    Color getColor(Component component, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop, Color color) {
        return this.getColor(new Skin(component, part, state), prop, color);
    }

    synchronized Border getBorder(Component component, TMSchema.Part part) {
        if (part == TMSchema.Part.MENU) {
            if (this.flatMenus) {
                return new XPFillBorder(UIManager.getColor("InternalFrame.borderShadow"), 1);
            }
            return null;
        }
        Skin skin = new Skin(component, part, null);
        Border border = this.borderMap.get(skin.string);
        if (border == null) {
            Insets insets;
            String string = XPStyle.getTypeEnumName(component, part, null, TMSchema.Prop.BGTYPE);
            if ("borderfill".equalsIgnoreCase(string)) {
                int n = this.getInt(component, part, null, TMSchema.Prop.BORDERSIZE, 1);
                Color color = this.getColor(skin, TMSchema.Prop.BORDERCOLOR, Color.black);
                border = new XPFillBorder(color, n);
            } else if ("imagefile".equalsIgnoreCase(string) && (insets = this.getMargin(component, part, null, TMSchema.Prop.SIZINGMARGINS)) != null) {
                border = this.getBoolean(component, part, null, TMSchema.Prop.BORDERONLY) ? new XPImageBorder(component, part) : (part == TMSchema.Part.TP_BUTTON ? new XPEmptyBorder(new Insets(3, 3, 3, 3)) : new XPEmptyBorder(insets));
            }
            if (border != null) {
                this.borderMap.put(skin.string, border);
            }
        }
        return border;
    }

    boolean isSkinDefined(Component component, TMSchema.Part part) {
        return part.getValue() == 0 || ThemeReader.isThemePartDefined(part.getControlName(component), part.getValue(), 0);
    }

    synchronized Skin getSkin(Component component, TMSchema.Part part) {
        assert (this.isSkinDefined(component, part)) : "part " + (Object)((Object)part) + " is not defined";
        return new Skin(component, part, null);
    }

    private XPStyle() {
        this.colorMap = new HashMap();
        this.borderMap = new HashMap();
    }

    private boolean getBoolean(Component component, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
        return ThemeReader.getBoolean(part.getControlName(component), part.getValue(), TMSchema.State.getValue(part, state), prop.getValue());
    }

    private static Dimension getPartSize(TMSchema.Part part, TMSchema.State state) {
        return ThemeReader.getPartSize(part.getControlName(null), part.getValue(), TMSchema.State.getValue(part, state));
    }

    private static boolean getSysBoolean(TMSchema.Prop prop) {
        return ThemeReader.getSysBoolean("window", prop.getValue());
    }

    static {
        skinPainter = new SkinPainter();
        themeActive = null;
        XPStyle.invalidateStyle();
    }

    static class GlyphButton
    extends JButton {
        private Skin skin;

        public GlyphButton(Component component, TMSchema.Part part) {
            XPStyle xPStyle = XPStyle.getXP();
            this.skin = xPStyle.getSkin(component, part);
            this.setBorder(null);
            this.setContentAreaFilled(false);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        protected TMSchema.State getState() {
            TMSchema.State state = TMSchema.State.NORMAL;
            if (!this.isEnabled()) {
                state = TMSchema.State.DISABLED;
            } else if (this.getModel().isPressed()) {
                state = TMSchema.State.PRESSED;
            } else if (this.getModel().isRollover()) {
                state = TMSchema.State.HOT;
            }
            return state;
        }

        public void paintComponent(Graphics graphics) {
            Dimension dimension = this.getSize();
            this.skin.paintSkin(graphics, 0, 0, dimension.width, dimension.height, this.getState());
        }

        public void setPart(Component component, TMSchema.Part part) {
            XPStyle xPStyle = XPStyle.getXP();
            this.skin = xPStyle.getSkin(component, part);
            this.revalidate();
            this.repaint();
        }

        protected void paintBorder(Graphics graphics) {
        }

        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }

    static class Skin {
        final Component component;
        final TMSchema.Part part;
        final TMSchema.State state;
        private final String string;
        private Dimension size = null;

        Skin(Component component, TMSchema.Part part) {
            this(component, part, null);
        }

        Skin(TMSchema.Part part, TMSchema.State state) {
            this(null, part, state);
        }

        Skin(Component component, TMSchema.Part part, TMSchema.State state) {
            this.component = component;
            this.part = part;
            this.state = state;
            String string = part.getControlName(component) + "." + part.name();
            if (state != null) {
                string = string + "(" + state.name() + ")";
            }
            this.string = string;
        }

        Insets getContentMargin() {
            return ThemeReader.getThemeMargins(this.part.getControlName(null), this.part.getValue(), 0, TMSchema.Prop.SIZINGMARGINS.getValue());
        }

        private int getWidth(TMSchema.State state) {
            if (this.size == null) {
                this.size = XPStyle.getPartSize(this.part, state);
            }
            return this.size.width;
        }

        int getWidth() {
            return this.getWidth(this.state != null ? this.state : TMSchema.State.NORMAL);
        }

        private int getHeight(TMSchema.State state) {
            if (this.size == null) {
                this.size = XPStyle.getPartSize(this.part, state);
            }
            return this.size.height;
        }

        int getHeight() {
            return this.getHeight(this.state != null ? this.state : TMSchema.State.NORMAL);
        }

        public String toString() {
            return this.string;
        }

        public boolean equals(Object object) {
            return object instanceof Skin && ((Skin)object).string.equals(this.string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        void paintSkin(Graphics graphics, int n, int n2, TMSchema.State state) {
            if (state == null) {
                state = this.state;
            }
            this.paintSkin(graphics, n, n2, this.getWidth(state), this.getHeight(state), state);
        }

        void paintSkin(Graphics graphics, Rectangle rectangle, TMSchema.State state) {
            this.paintSkin(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, state);
        }

        void paintSkin(Graphics graphics, int n, int n2, int n3, int n4, TMSchema.State state) {
            skinPainter.paint(null, graphics, n, n2, n3, n4, new Object[]{this, state});
        }

        void paintSkin(Graphics graphics, int n, int n2, int n3, int n4, TMSchema.State state, boolean bl) {
            if (bl && "borderfill".equals(XPStyle.getTypeEnumName(this.component, this.part, state, TMSchema.Prop.BGTYPE))) {
                return;
            }
            skinPainter.paint(null, graphics, n, n2, n3, n4, new Object[]{this, state});
        }
    }

    private static class SkinPainter
    extends CachedPainter {
        SkinPainter() {
            super(30);
            this.flush();
        }

        protected void paintToImage(Component component, Image image, Graphics graphics, int n, int n2, Object[] objectArray) {
            Skin skin = (Skin)objectArray[0];
            TMSchema.Part part = skin.part;
            TMSchema.State state = (TMSchema.State)((Object)objectArray[1]);
            if (state == null) {
                state = skin.state;
            }
            if (component == null) {
                component = skin.component;
            }
            WritableRaster writableRaster = ((BufferedImage)image).getRaster();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            ThemeReader.paintBackground(dataBufferInt.getData(), part.getControlName(component), part.getValue(), TMSchema.State.getValue(part, state), 0, 0, n, n2, n);
        }

        protected Image createImage(Component component, int n, int n2, GraphicsConfiguration graphicsConfiguration, Object[] objectArray) {
            return new BufferedImage(n, n2, 2);
        }
    }

    private class XPEmptyBorder
    extends EmptyBorder
    implements UIResource {
        XPEmptyBorder(Insets insets) {
            super(insets.top + 2, insets.left + 2, insets.bottom + 2, insets.right + 2);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, this.getBorderInsets());
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets = super.getBorderInsets(component, insets);
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                Insets insets3 = ((AbstractButton)component).getMargin();
                if (component.getParent() instanceof JToolBar && !(component instanceof JRadioButton) && !(component instanceof JCheckBox) && insets3 instanceof InsetsUIResource) {
                    insets.top -= 2;
                    insets.left -= 2;
                    insets.bottom -= 2;
                    insets.right -= 2;
                } else {
                    insets2 = insets3;
                }
            } else if (component instanceof JToolBar) {
                insets2 = ((JToolBar)component).getMargin();
            } else if (component instanceof JTextComponent) {
                insets2 = ((JTextComponent)component).getMargin();
            }
            if (insets2 != null) {
                insets.top = insets2.top + 2;
                insets.left = insets2.left + 2;
                insets.bottom = insets2.bottom + 2;
                insets.right = insets2.right + 2;
            }
            return insets;
        }
    }

    private class XPFillBorder
    extends LineBorder
    implements UIResource {
        XPFillBorder(Color color, int n) {
            super(color, n);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            } else if (component instanceof JToolBar) {
                insets2 = ((JToolBar)component).getMargin();
            } else if (component instanceof JTextComponent) {
                insets2 = ((JTextComponent)component).getMargin();
            }
            insets.top = (insets2 != null ? insets2.top : 0) + this.thickness;
            insets.left = (insets2 != null ? insets2.left : 0) + this.thickness;
            insets.bottom = (insets2 != null ? insets2.bottom : 0) + this.thickness;
            insets.right = (insets2 != null ? insets2.right : 0) + this.thickness;
            return insets;
        }
    }

    private class XPImageBorder
    extends AbstractBorder
    implements UIResource {
        Skin skin;

        XPImageBorder(Component component, TMSchema.Part part) {
            this.skin = XPStyle.this.getSkin(component, part);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            this.skin.paintSkin(graphics, n, n2, n3, n4, null);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            Insets insets3 = this.skin.getContentMargin();
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            } else if (component instanceof JToolBar) {
                insets2 = ((JToolBar)component).getMargin();
            } else if (component instanceof JTextComponent) {
                insets2 = ((JTextComponent)component).getMargin();
            }
            insets.top = (insets2 != null ? insets2.top : 0) + insets3.top;
            insets.left = (insets2 != null ? insets2.left : 0) + insets3.left;
            insets.bottom = (insets2 != null ? insets2.bottom : 0) + insets3.bottom;
            insets.right = (insets2 != null ? insets2.right : 0) + insets3.right;
            return insets;
        }
    }
}

