/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.verifier.statics;

import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.verifier.exc.AssertionViolatedException;
import com.sun.org.apache.bcel.internal.verifier.exc.LocalVariableInfoInconsistentException;
import com.sun.org.apache.bcel.internal.verifier.statics.DOUBLE_Upper;
import com.sun.org.apache.bcel.internal.verifier.statics.IntList;
import com.sun.org.apache.bcel.internal.verifier.statics.LONG_Upper;
import com.sun.org.apache.bcel.internal.verifier.statics.LocalVariableInfo;

public class LocalVariablesInfo {
    private LocalVariableInfo[] localVariableInfos;
    private IntList instruction_offsets = new IntList();

    LocalVariablesInfo(int n) {
        this.localVariableInfos = new LocalVariableInfo[n];
        for (int i = 0; i < n; ++i) {
            this.localVariableInfos[i] = new LocalVariableInfo();
        }
    }

    public LocalVariableInfo getLocalVariableInfo(int n) {
        if (n < 0 || n >= this.localVariableInfos.length) {
            throw new AssertionViolatedException("Slot number for local variable information out of range.");
        }
        return this.localVariableInfos[n];
    }

    public void add(int n, String string, int n2, int n3, Type type) throws LocalVariableInfoInconsistentException {
        if (n < 0 || n >= this.localVariableInfos.length) {
            throw new AssertionViolatedException("Slot number for local variable information out of range.");
        }
        this.localVariableInfos[n].add(string, n2, n3, type);
        if (type == Type.LONG) {
            this.localVariableInfos[n + 1].add(string, n2, n3, LONG_Upper.theInstance());
        }
        if (type == Type.DOUBLE) {
            this.localVariableInfos[n + 1].add(string, n2, n3, DOUBLE_Upper.theInstance());
        }
    }
}

