/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = 5595510919245408276L;
    private final PriorityQueue<E> q;
    private final ReentrantLock lock = new ReentrantLock(true);
    private final Condition notEmpty = this.lock.newCondition();

    public PriorityBlockingQueue() {
        this.q = new PriorityQueue();
    }

    public PriorityBlockingQueue(int n) {
        this.q = new PriorityQueue(n, null);
    }

    public PriorityBlockingQueue(int n, Comparator<? super E> comparator) {
        this.q = new PriorityQueue<E>(n, comparator);
    }

    public PriorityBlockingQueue(Collection<? extends E> collection) {
        this.q = new PriorityQueue<E>(collection);
    }

    @Override
    public boolean add(E e) {
        return super.add(e);
    }

    public Comparator<? super E> comparator() {
        return this.q.comparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = this.q.offer(e);
            assert (bl);
            this.notEmpty.signal();
            boolean bl2 = true;
            Object var6_5 = null;
            reentrantLock.unlock();
            return bl2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    @Override
    public void put(E e) {
        this.offer(e);
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        E e;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            try {
                while (this.q.size() == 0) {
                    this.notEmpty.await();
                }
            }
            catch (InterruptedException interruptedException) {
                this.notEmpty.signal();
                throw interruptedException;
            }
            E e2 = this.q.poll();
            assert (e2 != null);
            e = e2;
            Object var5_5 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        E e;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            e = this.q.poll();
            Object var4_3 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        return e;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public E poll(long var1_1, TimeUnit var3_2) throws InterruptedException {
        var4_3 = var3_2.toNanos(var1_1);
        var6_4 = this.lock;
        var6_4.lockInterruptibly();
        while (true) lbl-1000:
        // 2 sources

        {
            var7_5 = this.q.poll();
            if (var7_5 == null) break block7;
            var8_6 = var7_5;
            var10_9 = null;
            var6_4.unlock();
            break;
        }
        catch (Throwable var9_12) {
            var10_11 = null;
            var6_4.unlock();
            throw var9_12;
        }
        {
            block8: {
                block7: {
                    return var8_6;
                }
                if (var4_3 > 0L) break block8;
                var8_7 = null;
                var10_10 = null;
                var6_4.unlock();
                return var8_7;
            }
            try {
                var4_3 = this.notEmpty.awaitNanos(var4_3);
                continue;
            }
            catch (InterruptedException var8_8) {
                this.notEmpty.signal();
                throw var8_8;
            }
            ** while (true)
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        E e;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            e = this.q.peek();
            Object var4_3 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.q.size();
            Object var4_3 = null;
            reentrantLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = this.q.remove(object);
            Object var5_4 = null;
            reentrantLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object object) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = this.q.contains(object);
            Object var5_4 = null;
            reentrantLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.q.toArray();
            Object var4_3 = null;
            reentrantLock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            String string = this.q.toString();
            Object var4_3 = null;
            reentrantLock.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e;
            int n = 0;
            while ((e = this.q.poll()) != null) {
                collection.add(e);
                ++n;
            }
            int n2 = n;
            Object var7_6 = null;
            reentrantLock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        if (n <= 0) {
            return 0;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e;
            int n2;
            for (n2 = 0; n2 < n && (e = this.q.poll()) != null; ++n2) {
                collection.add(e);
            }
            int n3 = n2;
            Object var8_7 = null;
            reentrantLock.unlock();
            return n3;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            this.q.clear();
            Object var3_2 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] TArray) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            T[] TArray2 = this.q.toArray(TArray);
            Object var5_4 = null;
            reentrantLock.unlock();
            return TArray2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Itr<E> itr = new Itr<E>(this.q.iterator());
            Object var4_3 = null;
            reentrantLock.unlock();
            return itr;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.lock.lock();
        try {
            objectOutputStream.defaultWriteObject();
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr<E>
    implements Iterator<E> {
        private final Iterator<E> iter;

        Itr(Iterator<E> iterator) {
            this.iter = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            E e;
            ReentrantLock reentrantLock = PriorityBlockingQueue.this.lock;
            reentrantLock.lock();
            try {
                e = this.iter.next();
                Object var4_3 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            return e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            ReentrantLock reentrantLock = PriorityBlockingQueue.this.lock;
            reentrantLock.lock();
            try {
                this.iter.remove();
                Object var3_2 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }
    }
}

