/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import sun.awt.NativeLibLoader;
import sun.io.CharToByteConverter;
import sun.io.CharToByteUnicode;

public class FontDescriptor
implements Cloneable {
    String nativeName;
    public CharToByteConverter fontCharset;
    private int[] exclusionRanges;
    public CharToByteConverter unicodeCharset;
    boolean useUnicode;

    public FontDescriptor(String string, CharToByteConverter charToByteConverter, int[] nArray) {
        this.nativeName = string;
        this.fontCharset = charToByteConverter;
        this.exclusionRanges = nArray;
        this.useUnicode = false;
    }

    public String getNativeName() {
        return this.nativeName;
    }

    public CharToByteConverter getFontCharset() {
        return this.fontCharset;
    }

    public int[] getExclusionRanges() {
        return this.exclusionRanges;
    }

    public boolean isExcluded(char c) {
        int n = 0;
        while (n < this.exclusionRanges.length) {
            int n2 = this.exclusionRanges[n++];
            int n3 = this.exclusionRanges[n++];
            if (c < n2 || c > n3) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return super.toString() + " [" + this.nativeName + "|" + this.fontCharset + "]";
    }

    private static native void initIDs();

    public boolean useUnicode() {
        if (this.useUnicode && this.unicodeCharset == null) {
            this.unicodeCharset = new CharToByteUnicode(false);
        }
        return this.useUnicode;
    }

    static {
        NativeLibLoader.loadLibraries();
        FontDescriptor.initIDs();
    }
}

