/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Dialog;
import java.awt.Insets;
import java.awt.peer.DialogPeer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XModalStrategy;
import sun.awt.X11.XModalityProtocol;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XWindowPeer;

class XDialogPeer
extends XDecoratedPeer
implements DialogPeer {
    private Collection blocked = new LinkedList();
    private XModalStrategy modalStrategy;
    private Boolean undecorated;

    XDialogPeer(Dialog dialog) {
        super(dialog);
    }

    public void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        Dialog dialog = (Dialog)this.target;
        this.undecorated = dialog.isUndecorated();
        boolean bl = this.winAttr.nativeDecor = !dialog.isUndecorated();
        this.winAttr.decorations = this.winAttr.nativeDecor ? XWindowAttributesData.AWT_DECOR_ALL : XWindowAttributesData.AWT_DECOR_NONE;
        this.winAttr.isResizable = true;
        this.winAttr.initialResizability = dialog.isResizable();
        this.winAttr.title = dialog.getTitle();
        this.winAttr.initialState = XWindowAttributesData.NORMAL;
        this.winAttr.icon = null;
        this.modalStrategy = XModalStrategy.getModalStrategy(1);
    }

    protected String getWMName() {
        if (this.winAttr.title == null || this.winAttr.title.trim().equals("")) {
            return " ";
        }
        return this.winAttr.title;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (((Dialog)this.target).isModal()) {
                for (XModalityProtocol xModalityProtocol : XWM.getWM().getProtocols(XModalityProtocol.class)) {
                    if (!xModalityProtocol.setModal(this, true)) continue;
                    return;
                }
                if (!this.isModalBlocked()) {
                    XBaseWindow.ungrabInput();
                }
            }
            super.setVisible(true);
        } else {
            if (((Dialog)this.target).isModal()) {
                for (XModalityProtocol xModalityProtocol : XWM.getWM().getProtocols(XModalityProtocol.class)) {
                    if (!xModalityProtocol.setModal(this, false)) continue;
                    return;
                }
            }
            super.setVisible(false);
        }
    }

    public void handleMapNotifyEvent(long l) {
        super.handleMapNotifyEvent(l);
        if (((Dialog)this.target).isModal()) {
            for (XModalityProtocol xModalityProtocol : XWM.getWM().getProtocols(XModalityProtocol.class)) {
                if (!xModalityProtocol.setModal(this, true)) continue;
                return;
            }
        }
    }

    public void addModalBlocked(XWindowPeer xWindowPeer) {
        this.blocked.add(xWindowPeer);
    }

    public Collection getBlockedWindows() {
        return Collections.unmodifiableCollection(this.blocked);
    }

    public void clearBlockedWindows() {
        this.blocked.clear();
    }

    public XModalStrategy getModalStrategy() {
        return this.modalStrategy;
    }

    protected Insets guessInsets() {
        if (this.isTargetUndecorated()) {
            return new Insets(0, 0, 0, 0);
        }
        return super.guessInsets();
    }

    boolean isTargetUndecorated() {
        if (this.undecorated != null) {
            return this.undecorated;
        }
        return ((Dialog)this.target).isUndecorated();
    }
}

