/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import sun.awt.X11.AwtGraphicsConfigData;
import sun.awt.X11.IXAnyEvent;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11GraphicsConfig;

public abstract class XMenuWindow
extends XWindow {
    private static final String MENU_TARGET = "Menu target";
    MenuComponent menuTarget;
    Frame frame;

    XMenuWindow() {
        super((Object)null);
    }

    XMenuWindow(MenuComponent menuComponent) {
        super(new XCreateWindowParams(new Object[]{MENU_TARGET, menuComponent, "delayed", Boolean.TRUE}));
    }

    void instantPreInit(XCreateWindowParams xCreateWindowParams) {
        super.instantPreInit(xCreateWindowParams);
        Object v = xCreateWindowParams.get(MENU_TARGET);
        this.menuTarget = (MenuComponent)v;
    }

    abstract Frame getFrame();

    protected void initGraphicsConfiguration() {
        this.graphicsConfig = (X11GraphicsConfig)this.getFrame().getGraphicsConfiguration();
        this.graphicsConfigData = new AwtGraphicsConfigData(this.graphicsConfig.getAData());
    }

    public Object getTarget() {
        return this.menuTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toFront() {
        try {
            XToolkit.awtLock();
            XlibWrapper.XRaiseWindow(XToolkit.getDisplay(), this.window);
            XlibWrapper.XMapWindow(XToolkit.getDisplay(), this.window);
            this.visible = this.visible;
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    MouseEvent makeMouseEvent(MouseEvent mouseEvent, int n, int n2) {
        MouseEvent mouseEvent2 = new MouseEvent(this.getEventSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n, n2, mouseEvent.getClickCount(), false, mouseEvent.getButton());
        return mouseEvent2;
    }

    protected boolean isEventDisabled(IXAnyEvent iXAnyEvent) {
        switch (iXAnyEvent.get_type()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 17: {
                return super.isEventDisabled(iXAnyEvent);
            }
        }
        return true;
    }

    void postEvent(final AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent || aWTEvent instanceof ItemEvent) {
            super.postEvent(aWTEvent);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (!XMenuWindow.this.isVisible() || XMenuWindow.this.isDisposed()) {
                    return;
                }
                XMenuWindow.this.handleEvent(aWTEvent);
            }
        });
    }

    private void handleEvent(AWTEvent aWTEvent) {
        switch (aWTEvent.getID()) {
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: {
                this.handleJavaMouseEvent((MouseEvent)aWTEvent);
                break;
            }
            case 401: 
            case 402: {
                this.handleJavaKeyEvent((KeyEvent)aWTEvent);
                break;
            }
            case 800: {
                this.handleJavaPaintEvent((PaintEvent)aWTEvent);
            }
        }
    }

    void handleJavaPaintEvent(PaintEvent paintEvent) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void handleJavaMouseEvent(MouseEvent mouseEvent) {
    }

    void handleJavaKeyEvent(KeyEvent keyEvent) {
    }

    void setVisible(boolean bl) {
        this.xSetVisible(bl);
    }

    public void doDispose() {
        this.setVisible(false);
        XToolkit.targetDisposedPeer(this.getMenuTarget(), this);
        if (this.surfaceData != null) {
            XToolkit.removeSourceEvents(XToolkit.getEventQueue(this.menuTarget), this.menuTarget, true);
            super.dispose();
        }
    }

    public void dispose() {
        this.setDisposed(true);
        this.setVisible(false);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                XMenuWindow.this.doDispose();
            }
        });
    }

    public Component getEventSource() {
        return this.frame;
    }

    MenuComponent getMenuTarget() {
        return this.menuTarget;
    }

    void setMenuTarget(MenuComponent menuComponent) {
        this.menuTarget = menuComponent;
    }
}

