/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Shape;
import java.awt.peer.MenuBarPeer;
import sun.awt.X11GraphicsConfig;
import sun.awt.motif.MFramePeer;
import sun.awt.motif.MMenuItemPeer;
import sun.awt.motif.MToolkit;
import sun.awt.motif.MWindowAttributes;
import sun.awt.motif.MWindowPeer;

public class MMenuBarPeer
implements MenuBarPeer {
    long pData;
    MenuBar target;
    private X11GraphicsConfig graphicsConfig = null;
    private boolean disposed = false;
    static final int GAP = 10;
    static final int W_DIFF = 12;
    static final int H_DIFF = 23;

    private static native void initIDs();

    native void create(MFramePeer var1);

    public MMenuBarPeer(MenuBar menuBar) {
        this.target = menuBar;
        MFramePeer mFramePeer = (MFramePeer)MToolkit.targetToPeer(MMenuItemPeer.getParent_NoClientCode(menuBar));
        this.create(mFramePeer);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private native void pDispose();

    protected void disposeImpl() {
        MToolkit.targetDisposedPeer(this.target, this);
        this.pDispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        boolean bl = false;
        if (!this.disposed) {
            MMenuBarPeer mMenuBarPeer = this;
            synchronized (mMenuBarPeer) {
                if (!this.disposed) {
                    bl = true;
                    this.disposed = true;
                }
            }
        }
        if (bl) {
            this.disposeImpl();
        }
    }

    public void addMenu(Menu menu) {
    }

    public void delMenu(int n) {
    }

    public void addHelpMenu(Menu menu) {
    }

    void print(Graphics graphics) {
        Object object;
        MenuBar menuBar = this.target;
        Frame frame = (Frame)MMenuItemPeer.getParent_NoClientCode(this.target);
        Dimension dimension = frame.size();
        Insets insets = frame.insets();
        int n = dimension.width;
        int n2 = insets.top;
        if (frame.getPeer() instanceof MFramePeer) {
            object = (MFramePeer)frame.getPeer();
            if (((MWindowPeer)object).hasDecorations(MWindowAttributes.AWT_DECOR_BORDER)) {
                n -= 12;
                n2 -= 6;
            }
            if (((MWindowPeer)object).hasDecorations(MWindowAttributes.AWT_DECOR_MENU)) {
                n2 -= 17;
            }
        }
        object = new Dimension(n, n2);
        Shape shape = graphics.getClip();
        graphics.clipRect(0, 0, ((Dimension)object).width, ((Dimension)object).height);
        Color color = frame.getBackground();
        Color color2 = frame.getForeground();
        Color color3 = color.brighter();
        Color color4 = color.darker();
        if (color3.equals(Color.white)) {
            graphics.setColor(new Color(230, 230, 230));
        } else {
            graphics.setColor(color3);
        }
        graphics.drawLine(0, 0, ((Dimension)object).width, 0);
        graphics.drawLine(1, 1, ((Dimension)object).width - 1, 1);
        graphics.drawLine(0, 0, 0, ((Dimension)object).height);
        graphics.drawLine(1, 1, 1, ((Dimension)object).height - 1);
        graphics.setColor(color4);
        graphics.drawLine(((Dimension)object).width, 1, ((Dimension)object).width, ((Dimension)object).height);
        graphics.drawLine(((Dimension)object).width - 1, 2, ((Dimension)object).width - 1, ((Dimension)object).height);
        graphics.drawLine(1, ((Dimension)object).height, ((Dimension)object).width, ((Dimension)object).height);
        graphics.drawLine(2, ((Dimension)object).height - 1, ((Dimension)object).width, ((Dimension)object).height - 1);
        int n3 = 10;
        int n4 = menuBar.countMenus();
        Menu menu = this.target.getHelpMenu();
        for (int i = 0; i < n4; ++i) {
            Menu menu2 = this.target.getMenu(i);
            String string = menu2.getLabel();
            if (string == null) {
                string = "";
            }
            Font font = menu2.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n5 = ((Dimension)object).height / 2 + fontMetrics.getMaxDescent();
            int n6 = fontMetrics.stringWidth(string) + 20;
            if (n3 >= ((Dimension)object).width) break;
            if (menu2.isEnabled()) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(color4);
            }
            if (menu == menu2) {
                graphics.drawString(string, ((Dimension)object).width - n6 + 10, n5);
                continue;
            }
            graphics.drawString(string, n3, n5);
            n3 += n6;
        }
        graphics.setClip(shape);
    }

    public void setFont(Font font) {
    }

    static {
        MMenuBarPeer.initIDs();
    }
}

