/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import sun.awt.X11ComponentPeer;
import sun.java2d.SurfaceData;
import sun.java2d.loops.SurfaceType;
import sun.java2d.opengl.GLXGraphicsConfig;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLSurfaceData;

public abstract class GLXSurfaceData
extends OGLSurfaceData {
    protected X11ComponentPeer peer;
    private GLXGraphicsConfig graphicsConfig;

    private static native void initIDs(Class var0);

    private native void initOps(X11ComponentPeer var1, GLXGraphicsConfig var2);

    protected native boolean initWindow(long var1);

    protected native boolean initPbuffer(long var1, long var3, int var5, int var6);

    protected native boolean initPixmap(long var1, long var3, int var5, int var6, int var7);

    protected GLXSurfaceData(X11ComponentPeer x11ComponentPeer, GLXGraphicsConfig gLXGraphicsConfig, SurfaceType surfaceType, ColorModel colorModel, int n) {
        super(surfaceType, colorModel, n);
        this.peer = x11ComponentPeer;
        this.graphicsConfig = gLXGraphicsConfig;
        this.solidloops = this.graphicsConfig.getSolidLoops(surfaceType);
        this.initOps(x11ComponentPeer, this.graphicsConfig);
    }

    public boolean initWindow() {
        if (this.initWindow(this.getNativeOps())) {
            if (this.type == 0) {
                this.type = 1;
            }
            return true;
        }
        return false;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    public OGLContext getContext() {
        return this.graphicsConfig.getContext();
    }

    public long getSharedContext() {
        GLXSurfaceData gLXSurfaceData = this;
        return gLXSurfaceData.graphicsConfig.getThreadSharedContext();
    }

    public boolean isBlendPremultAvailable() {
        return this.graphicsConfig.isBlendPremultAvailable();
    }

    public boolean isTexNonPow2Available() {
        return this.graphicsConfig.isTexNonPow2Available();
    }

    public static GLXWindowSurfaceData createData(X11ComponentPeer x11ComponentPeer) {
        GLXGraphicsConfig gLXGraphicsConfig = GLXSurfaceData.getGC(x11ComponentPeer);
        return new GLXWindowSurfaceData(x11ComponentPeer, gLXGraphicsConfig);
    }

    public static GLXOffScreenSurfaceData createData(X11ComponentPeer x11ComponentPeer, boolean bl) {
        GLXGraphicsConfig gLXGraphicsConfig = GLXSurfaceData.getGC(x11ComponentPeer);
        Rectangle rectangle = x11ComponentPeer.getBounds();
        int n = bl ? 6 : 5;
        return new GLXOffScreenSurfaceData(x11ComponentPeer, gLXGraphicsConfig, rectangle.width, rectangle.height, null, x11ComponentPeer.getColorModel(), n);
    }

    public static GLXOffScreenSurfaceData createData(GLXGraphicsConfig gLXGraphicsConfig, int n, int n2, ColorModel colorModel, Image image, int n3) {
        return new GLXOffScreenSurfaceData(null, gLXGraphicsConfig, n, n2, image, colorModel, n3);
    }

    public static GLXGraphicsConfig getGC(X11ComponentPeer x11ComponentPeer) {
        if (x11ComponentPeer != null) {
            return (GLXGraphicsConfig)x11ComponentPeer.getGraphicsConfiguration();
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        return (GLXGraphicsConfig)graphicsDevice.getDefaultConfiguration();
    }

    static {
        GLXSurfaceData.initIDs(GLXGraphicsConfig.class);
    }

    public static class GLXOffScreenSurfaceData
    extends GLXSurfaceData {
        private Image offscreenImage;
        private int width;
        private int height;
        private int transparency;

        public GLXOffScreenSurfaceData(X11ComponentPeer x11ComponentPeer, GLXGraphicsConfig gLXGraphicsConfig, int n, int n2, Image image, ColorModel colorModel, int n3) {
            super(x11ComponentPeer, gLXGraphicsConfig, n3 == 4 ? OpenGLTexture : OpenGLSurface, colorModel, n3);
            this.width = n;
            this.height = n2;
            this.offscreenImage = image;
            this.transparency = colorModel.getTransparency();
            this.initSurface(n, n2, this.depth);
        }

        public SurfaceData getReplacement() {
            return GLXOffScreenSurfaceData.restoreContents(this.offscreenImage);
        }

        public int getTransparency() {
            return this.transparency;
        }

        public Rectangle getBounds() {
            if (this.type == 6) {
                Rectangle rectangle = this.peer.getBounds();
                rectangle.y = 0;
                rectangle.x = 0;
                return rectangle;
            }
            return new Rectangle(this.width, this.height);
        }
    }

    public static class GLXWindowSurfaceData
    extends GLXSurfaceData {
        public GLXWindowSurfaceData(X11ComponentPeer x11ComponentPeer, GLXGraphicsConfig gLXGraphicsConfig) {
            super(x11ComponentPeer, gLXGraphicsConfig, OpenGLSurface, x11ComponentPeer.getColorModel(), 0);
        }

        public SurfaceData getReplacement() {
            return this.peer.getSurfaceData();
        }

        public Rectangle getBounds() {
            Rectangle rectangle = this.peer.getBounds();
            rectangle.y = 0;
            rectangle.x = 0;
            return rectangle;
        }
    }
}

