/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public final class ICUBinary {
    private static final byte MAGIC1 = -38;
    private static final byte MAGIC2 = 39;
    private static final byte BIG_ENDIAN_ = 1;
    private static final byte CHAR_SET_ = 0;
    private static final byte CHAR_SIZE_ = 2;
    private static final String MAGIC_NUMBER_AUTHENTICATION_FAILED_ = "ICU data file error: Not an ICU data file";
    private static final String HEADER_AUTHENTICATION_FAILED_ = "ICU data file error: Header authentication failed, please check if you have a valid ICU data file";

    public static final byte[] readHeader(InputStream inputStream, byte[] byArray, Authenticate authenticate) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        char c = dataInputStream.readChar();
        c = (char)(c - 2);
        byte by = dataInputStream.readByte();
        c = (char)(c - '\u0001');
        byte by2 = dataInputStream.readByte();
        c = (char)(c - '\u0001');
        if (by != -38 || by2 != 39) {
            throw new IOException(MAGIC_NUMBER_AUTHENTICATION_FAILED_);
        }
        dataInputStream.readChar();
        c = (char)(c - 2);
        dataInputStream.readChar();
        c = (char)(c - 2);
        byte by3 = dataInputStream.readByte();
        c = (char)(c - '\u0001');
        byte by4 = dataInputStream.readByte();
        c = (char)(c - '\u0001');
        byte by5 = dataInputStream.readByte();
        c = (char)(c - '\u0001');
        dataInputStream.readByte();
        c = (char)(c - '\u0001');
        byte[] byArray2 = new byte[4];
        dataInputStream.readFully(byArray2);
        c = (char)(c - 4);
        byte[] byArray3 = new byte[4];
        dataInputStream.readFully(byArray3);
        c = (char)(c - 4);
        byte[] byArray4 = new byte[4];
        dataInputStream.readFully(byArray4);
        c = (char)(c - 4);
        dataInputStream.skipBytes(c);
        if (by3 != 1 || by4 != 0 || by5 != 2 || !Arrays.equals(byArray, byArray2) || authenticate != null && !authenticate.isDataVersionAcceptable(byArray3)) {
            throw new IOException(HEADER_AUTHENTICATION_FAILED_);
        }
        return byArray4;
    }

    public static interface Authenticate {
        public boolean isDataVersionAcceptable(byte[] var1);
    }
}

