/**
 * Copyright (c) 2001/2003 Distributed Systems Research Group.
 * All rights reserved.
 *
 * For more information on Distributed Systems Research Group (DSRG),
 * please see <http://www.ics.agh.edu.pl/>.
 *
 * @author radzisz
 * file name: FortuneClient.java
 *
 */
package edu.agh.dsrg.sius.fortune;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class FortuneClient {

	public static void main(String[] args) {

		System.out.println(new FortuneClient().getFortune());
	}

	public String getFortune() {

		try {
			FortuneTellerSBHome home =
				(FortuneTellerSBHome) lookupHome("java:/ejb/FortuneSB");
			FortuneTellerSB fortuneTeller = home.create();
			return fortuneTeller.getFortune();
		} catch (NamingException e) {
			e.printStackTrace();
		} catch (CreateException e) {
			e.printStackTrace();
		} catch (RemoteException e) {
			e.printStackTrace();
		}
		return "Could not get fortune";
	}
	

	/**
	  * Look up the bean's home interface using JNDI.
	  */
	private Object lookupHome(String name) throws NamingException {
		Context ctx = getInitialContext();
		log("Have initial context");

		try {
			Object home = ctx.lookup(name);
			log("Home looked up");
			return home;

		} catch (NamingException ne) {
			log(
				"The client was unable to lookup the EJBHome.  Please make sure "
					+ "that you have deployed the ejb with the JNDI name "
					+ name);

			throw ne;
		}
	}

	/**
	 * Get an initial context into the JNDI tree.
	 *
	 * Java2 clients can use the jndi.properties file to set the
	 * INITIAL_CONTEXT_FACTORY and the PROVIDER_URL
	 *
	 * Using a Properties object will work on JDK 1.1.x and Java2
	 * clients
	 */
	private Context getInitialContext() throws NamingException {

		try {
			// Get an InitialContext
			return new InitialContext();
		} catch (NamingException ne) {
			log("We were unable to get a connection to the  server ");
			log("Please make sure that the server is running.");
			throw ne;
		}
	}

	private void log(String text) {
		System.out.println(text);
	}

}
