/**
 * Copyright (c) 2001/2003 Distributed Systems Research Group.
 * All rights reserved.
 *
 * For more information on Distributed Systems Research Group (DSRG),
 * please see <http://www.ics.agh.edu.pl/>.
 *
 * @author radzisz
 * file name: FortuneTellerEJB.java
 *
 */
package edu.agh.dsrg.sius.fortune;

import java.rmi.RemoteException;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.rmi.PortableRemoteObject;

import org.apache.log4j.Logger;

public class FortuneTellerEJB implements SessionBean {

	private static Logger logger =
		Logger.getLogger("edu.agh.dsrg.sius.fortune");
	private SessionContext context;


	public void ejbCreate() throws CreateException {
		logger.info("Creating FortuneTellerEJB");
	}

	/**
	 * method returns fortune - the bussines method of the bean
	 */
	public String getFortune() {
		logger.info("getFortuneCalled");
		return "dummyFortune";
	}


	/**
	 * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
	 */
	public void setSessionContext(SessionContext arg0)
		throws EJBException, RemoteException {
		logger.info("setSessionContextCalled");
		context = arg0;
	}

	/**
	 * @see javax.ejb.SessionBean#ejbRemove()
	 */
	public void ejbRemove() throws EJBException, RemoteException {
		logger.info("ejbRemove called");
	}

	/**
	 * @see javax.ejb.SessionBean#ejbActivate()
	 */
	public void ejbActivate() throws EJBException, RemoteException {
		logger.info("ejbActivate called");
	}

	/**
	 * @see javax.ejb.SessionBean#ejbPassivate()
	 */
	public void ejbPassivate() throws EJBException, RemoteException {
		logger.info("ejbPasivate called");
	}

}
