/**
 * Copyright (c) 2001/2003 Distributed Systems Research Group.
 * All rights reserved.
 *
 * For more information on Distributed Systems Research Group (DSRG),
 * please see <http://www.ics.agh.edu.pl/>.
 *
 * @author radzisz
 * file name: FortuneEJB.java
 *
 */
package edu.agh.dsrg.sius.fortune;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.SessionContext;

import org.apache.log4j.Logger;

public abstract class FortuneCMP implements EntityBean {

	private static Logger logger =
		Logger.getLogger("edu.agh.dsrg.sius.fortuneEB");

	/**
	 * accessor methods
	 */
	public abstract Integer getId();
	public abstract void setId(Integer id);
	public abstract String getText();
	public abstract void setText(String text);

	/**
	 * creation method 
	 */
	public Integer ejbCreate(String text) throws CreateException {
		Integer id = new Integer((int) (Math.random() * 10000));
		//sequencer bean or DB sequence should be used here
		setId(id);
		setText(text);
		logger.info("Creating FortuneEJB with id: " + id + ", text:" + text);
		return null;
	}
	public void ejbPostCreate(String text) throws CreateException {
		logger.info("ejbPostCreate() called");		
	}

	/*********** Entity bean specific methods ******************/

	/**
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext arg0)
		throws EJBException, RemoteException {
		logger.info("setEntityContext() called");
	}

	/**
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
		logger.info("unsetEntityContext() called");
	}

	/**
	 * @see javax.ejb.EntityBean#ejbLoad()
	 */
	public void ejbLoad() throws EJBException, RemoteException {
		logger.info("ejbLoad() called");
	}

	/**
	 * @see javax.ejb.EntityBean#ejbStore()
	 */
	public void ejbStore() throws EJBException, RemoteException {
		logger.info("ejbStore() called");
	}

	/**
	 * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
	 */
	public void setSessionContext(SessionContext arg0)
		throws EJBException, RemoteException {
		logger.info("setSessionContextCalled");
	}

	/**
	 * @see javax.ejb.SessionBean#ejbRemove()
	 */
	public void ejbRemove() throws EJBException, RemoteException {
		logger.info("ejbRemove called");
	}

	/**
	 * @see javax.ejb.SessionBean#ejbActivate()
	 */
	public void ejbActivate() throws EJBException, RemoteException {
		logger.info("ejbActivate called");
	}

	/**
	 * @see javax.ejb.SessionBean#ejbPassivate()
	 */
	public void ejbPassivate() throws EJBException, RemoteException {
		logger.info("ejbPasivate called");
	}

}
