/**
 * Copyright (c) 2001/2003 Distributed Systems Research Group.
 * All rights reserved.
 *
 * For more information on Distributed Systems Research Group (DSRG),
 * please see <http://www.ics.agh.edu.pl/>.
 *
 * @author radzisz
 * file name: FortuneTellerEJB.java
 *
 */
package edu.agh.dsrg.sius.fortune;

import java.rmi.RemoteException;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.log4j.Logger;

public class FortuneTellerEJB implements SessionBean {

	private static Logger logger =
		Logger.getLogger("edu.agh.dsrg.sius.fortune");
	private SessionContext context;

	private FortuneEBLocalHome fortuneEBLocalHome;

	public void ejbCreate() throws CreateException {
		logger.info("Creating FortuneTellerEJB");

		try {
			InitialContext ic = new InitialContext();
			logger.info("get initialcontext");
			String fortuneEBHomeJNDI =
				(String) ic.lookup("java:/comp/env/fortuneSB");
			logger.info(
				"get Bean property name: fortuneSB, value: "
					+ fortuneEBHomeJNDI);

			java.lang.Object objref = ic.lookup(fortuneEBHomeJNDI);
			
			logger.info("get local object reference");			
			fortuneEBLocalHome = (FortuneEBLocalHome) objref;

			logger.info("get fortune localHome reference");

		} catch (NamingException e) {
			logger.error("naming exception", e);
			throw new CreateException(
				"could not get reference to entity bean" + e);
		}
	}

	/**
	 * method returns fortune - the bussines method of the bean
	 */
	public String getFortune() {
		logger.info("getFortuneCalled");
		Collection fortunes;
		try {
			fortunes = fortuneEBLocalHome.findAll();
			if (fortunes.size() > 0) {
				int which = (int) (Math.random() * fortunes.size());
				FortuneEBLocal fortune =
					(FortuneEBLocal) fortunes.toArray(
						new FortuneEBLocal[0])[which];
				logger.info("got fortune - " + fortune.getText());
				return fortune.getText();
			} else
				logger.info("no fortunes in db - dummyFortune");
		} catch (FinderException e) {
			logger.error("could not find fortune", e);
		}
		return "dummyFortune";
	}

	/**
	 * method adds new fortune to data base
	 */
	public void addFortune(String text) {
		logger.info("addFortune called");
		try {
			fortuneEBLocalHome.create(text);
			logger.info("fortune created: " + text);
		} catch (CreateException e) {
			logger.info("could not create fortune", e);
		}
	}

	/**
	 * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
	 */
	public void setSessionContext(SessionContext arg0)
		throws EJBException, RemoteException {
		logger.info("setSessionContextCalled");
		context = arg0;
	}

	/**
	 * @see javax.ejb.SessionBean#ejbRemove()
	 */
	public void ejbRemove() throws EJBException, RemoteException {
		logger.info("ejbRemove called");
	}

	/**
	 * @see javax.ejb.SessionBean#ejbActivate()
	 */
	public void ejbActivate() throws EJBException, RemoteException {
		logger.info("ejbActivate called");
	}

	/**
	 * @see javax.ejb.SessionBean#ejbPassivate()
	 */
	public void ejbPassivate() throws EJBException, RemoteException {
		logger.info("ejbPasivate called");
	}

}
